// StcLedBtn.cpp : implementation file
//

#include "stdafx.h"
#include "DioControl.h"
#include "StcLedBtn.h"
#include "../common/ceSDK.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStcLedBtn

CStcLedBtn::CStcLedBtn()
{
	m_bLedState = 0;
	m_nMode = 0;

	m_strText = _T("N/A");

	m_LedBtnBmp[DI_OFF].LoadBitmap(IDB_BMP_DIOFF);
	m_LedBtnBmp[DI_ON].LoadBitmap(IDB_BMP_DION);
	m_LedBtnBmp[DO_OFF].LoadBitmap(IDB_BMP_DOOFF);
	m_LedBtnBmp[DO_ON].LoadBitmap(IDB_BMP_DOON);
}

CStcLedBtn::~CStcLedBtn()
{
}


BEGIN_MESSAGE_MAP(CStcLedBtn, CStatic)
	//{{AFX_MSG_MAP(CStcLedBtn)
	ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStcLedBtn message handlers

VOID CStcLedBtn::SetDoOn()
{
	LONG nRet = 0;
	const LONG nDioMode = 3;
	
	if( m_nMode == DO_MODE )
	{
		nRet = cedioOne_Put( m_nChannel, TRUE );
		
		if( nRet == ceERR_NONE )
		{
			//SetBitmap(m_LedBtnBmp[nDioMode]);
			m_bLedState = ON;
		}
	}
}

VOID CStcLedBtn::SetDoOff()
{
	LONG nRet = 0;
	const LONG nDioMode = 2;
	
	if( m_nMode == DO_MODE )
	{
		nRet = cedioOne_Put( m_nChannel, FALSE );
		
		if( nRet == ceERR_NONE )
		{
			//SetBitmap( m_LedBtnBmp[nDioMode] );
			m_bLedState = OFF;
		}
	}
}

//Digital Output Bitmap̹ Ʈ մϴ. 
//   ʽϴ.
VOID CStcLedBtn::SetBmp( const BOOL bOnOff )
{
	BOOL bState = bOnOff ? TRUE : FALSE;
	BOOL bMode = m_nMode ? DO_MODE : DI_MODE;

	SetBitmap( m_LedBtnBmp[ 2 * m_nMode + bState ] );

	m_bLedState = bState;
	Invalidate();
}

BOOL CStcLedBtn::GetCurState()
{
	return m_bLedState;
}


void CStcLedBtn::OnClicked() 
{
	// TODO: Add your control notification handler code here
	
	if( m_nMode == DI_MODE ) return;

	BOOL bCurSta = GetCurState();
	bCurSta ?  SetDoOff() : SetDoOn();
	//Invalidate();
}


VOID CStcLedBtn::SetChnlNMode(const LONG nChannel, const LONG nMode)
{
	if( nMode < 0 || nMode >= 2 )
	{
		m_nMode = DI_MODE;
	}
	else
	{
		m_nMode = nMode;
	}

	m_nChannel = nChannel;

	if( nMode == DI_MODE )
	{
		SetBitmap(m_LedBtnBmp[DI_OFF]);

		m_strText.Format("DI %d", nChannel);
	}
	else //tDioMode.DO
	{
		SetBitmap(m_LedBtnBmp[DO_OFF]);

		m_strText.Format("DO %d", nChannel);
	}
}


VOID CStcLedBtn::DrawBitmap( CDC *pDC)
{
	CDC memDC;
	CBitmap *pOldBmp;
	BITMAP bm;
	CRect rect;

	LONG nCurSelBmp = 0;

	nCurSelBmp = ( m_nMode == DI_MODE ) ? 0 : 2;
	nCurSelBmp += ( m_bLedState == OFF ) ? 0 : 1;

	//if( nCurSelBmp >= tDioOnOff.Count || nCurSelBmp < 0 ) return;
	//if( bmp.m_hObject == NULL )return;
	
	m_LedBtnBmp[nCurSelBmp].GetBitmap(&bm);

	memDC.CreateCompatibleDC(pDC);

	pOldBmp = memDC.SelectObject(&m_LedBtnBmp[nCurSelBmp]);
	
	GetClientRect(&rect);

	pDC->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), &memDC, 0, 0, SRCCOPY );

	pDC->SetBkMode( TRANSPARENT );
	pDC->DrawText(m_strText, rect, DT_CENTER | DT_WORDBREAK );

	memDC.SelectObject(pOldBmp);
}

void CStcLedBtn::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	DrawBitmap(&dc);
	// Do not call CStatic::OnPaint() for painting messages
}

LONG CStcLedBtn::GetBtnMode()
{
	return m_nMode;
}
